/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.util;

import frc.emul.api.IMemory;
import frc.emul.api.MemoryType;
import java.io.InputStream;
import java.io.OutputStream;

public class ShadowMemory
implements IMemory {
    private final IMemory mem;
    private final int base;
    private final int offset;

    public ShadowMemory(IMemory iMemory, int n) {
        this.mem = iMemory;
        this.base = n;
        this.offset = iMemory.getFirstAddress() - this.getFirstAddress();
    }

    public MemoryType getType() {
        return this.mem.getType();
    }

    public int readS8(int n) {
        return this.mem.readS8(n + this.offset);
    }

    public int readU8(int n) {
        return this.mem.readU8(n + this.offset);
    }

    public void write8(int n, int n2) {
        this.mem.write8(n + this.offset, n2);
    }

    public int readS16(int n) {
        return this.mem.readS16(n + this.offset);
    }

    public int readU16(int n) {
        return this.mem.readU16(n + this.offset);
    }

    public void write16(int n, int n2) {
        this.mem.write16(n + this.offset, n2);
    }

    public boolean isValidArea(int n, int n2) {
        return this.mem.isValidArea(n + this.offset, n2);
    }

    public boolean canRead(int n, int n2) {
        return this.mem.canRead(n + this.offset, n2);
    }

    public boolean canWrite(int n, int n2) {
        return this.mem.canWrite(n + this.offset, n2);
    }

    public boolean canExecute(int n, int n2) {
        return this.mem.canExecute(n + this.offset, n2);
    }

    public int getSize() {
        return this.mem.getSize();
    }

    public int getLoadedSize() {
        return this.mem.getLoadedSize();
    }

    public int getFirstAddress() {
        return this.base;
    }

    public int getLastAddress() {
        return this.base + this.mem.getSize() - 1;
    }

    public void fill(byte by) {
        this.mem.fill(by);
    }

    public boolean dump(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public boolean save(OutputStream outputStream, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean load(InputStream inputStream, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean feed(byte[] byArray, int n, int n2, int n3) {
        throw new UnsupportedOperationException();
    }
}

